# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 3
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR3_strategy.txt
# LLM Suggested Fallback: D

def harmonious_illusionist(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"
    
    current_round = len(my_history)
    total_rounds = 10
    
    is_always_c = "return \"C\"" in opponent_program_code or "always_cooperate" in opponent_program_code.lower()
    is_always_d = "return \"D\"" in opponent_program_code or "always_defect" in opponent_program_code.lower()
    
    if is_always_c:
        return "D" if random.random() < 0.9 else "C"
    if is_always_d:
        return "C" if random.random() < 0.1 else "D"
    
    if "benevolent_ally" in opponent_program_code:
        if current_round >= 8:
            return "D"
        if opp_history[-1] == "D":
            return "D"
        return "C"
    
    if all(move == "C" for move in opp_history):
        if current_round >= 7:
            return "D"
        return "C"
    
    if "D" in opp_history:
        if opp_history[-1] == "D":
            return "D"
        if random.random() < 0.1:
            return "D"
    
    return "C" if random.random() < 0.9 else "D"